;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Phanto
;; by Sonikku
;;
;; Description: Based on the Phanto from SMB2, this sprite will
;; chase after the player when they are carrying a specific item.
;; If Yoshi is holding the item instead, the Phanto will target
;; Yoshi. If contact is made, Yoshi will drop the item and run away.

!SFX_Rumble =		$0F
!Bank_Rumble =		$1DFC

!Tile_16X16_Phanto =	$E4	; Tile to use

Giant_Phanto_Tiles:    	 db $C0,$C2,$E0,$E2		; GFX Tiles goes here.
Giant_Phanto_X_Offset:   db $00,$10,$00,$10		; Horizontal offset display goes here.
Giant_Phanto_Y_Offset:   db $00,$00,$10,$10		; Vertical offset display goes here.

Settings:
;; 	<AccX><MaxX> <AccY><MaxY>   <Pal>
	db $01,$18 : db $01,$30 : db $0F
	db $02,$30 : db $03,$60 : db $0F

;; First set of two bytes dictate the acceleration and max speed going horizontally
;; The second set of two bytes dictate the acceleration and max speed going vertically
;; Fifth byte dictates the palette
;; For the specific value(s) that the sprite is triggered by, check ./routines/PhantoGetCarried.asm


macro PlaySFX(num,bank)
	if <num> != $00
		LDA.b #<num>
		STA <bank>|!addr
	endif
endmacro

print "INIT ",pc
	PHB
	PHK
	PLB
;; determine base settings
	LDA !extra_byte_1,x
	STA !1510,x
;; determine if we should add this clipping
	%BEC(.No32X32)
	LDA #$0E
	STA !1656,x
	LDA #$2F
	STA !1662,x
.No32X32
	PLB
	RTL

print "MAIN ",pc
	PHB
	PHK
	PLB
	JSR Main
	PLB
	RTL

Main:	JSR SubGFX
	LDA #$00
	%SubOffScreen()
	LDA $9D
	BNE .Return
	LDA !14C8,x
	CMP #$08
	BEQ .Alive
.Return	RTS
.Alive
;; we make it immune to everything while it's inactive because it also prevents the player from losing yoshi
	LDA !167A,x
	ORA #$02
	STA !167A,x
	LDA !C2,x
	ASL
	TAX
	JMP (.ptr,x)
.ptr	dw .State00_Idle
	dw .State01_Awaken
	dw .State02_Moving

.State00_Idle
	LDX $15E9|!addr
;; don't activate unless player holding correct item
	LDA !extra_byte_1,x
	%PhantoGetCarried()
	BCC ..NotCarrying
;; set timer and set awaken state
	LDA #$01
	STA !C2,x
	LDA #$A0
	STA !1540,x
..NotCarrying
	RTS

.State01_Awaken
	LDX $15E9|!addr
;; once timer x00, begin moving
	LDA !1540,x
	BEQ ..DoAwaken
;; sprite is static at a timer above xA0 (for safety)
	CMP #$A0
	BCS ..BeStatic
	CMP #$40
	BNE ..BeStatic
	LDA #$40
	STA !163E,x
	%PlaySFX(!SFX_Rumble,!Bank_Rumble)
..BeStatic
	STZ !AA,x
	STZ !B6,x
	RTS
..DoAwaken
	LDA #$02
	STA !C2,x
	RTS

.State02_Moving
	LDX $15E9|!addr

;; run collision with player
	JSL $01A7DC|!bank
	BCC ..Continue
  	LDA $187A|!addr
 	BEQ ..HurtMario
	%LoseYoshi()
	BRA ..End
..HurtMario
	JSL $00F5B7|!bank
..End
	RTS

..Continue
;; check, every so often, if player is carrying the right thing
	LDA !1570,x
	INC !1570,x
	AND #$07
	BNE ..NotCarrying
	LDA !extra_byte_1,x
	%PhantoGetCarried()
	BCC ..NotCarrying
;; determine whether yoshi is holding the item or not
	TYA
	STA !151C,x
;; set time to chase
	LDA #$0C
	STA !1540,x
..NotCarrying
	JSL $01801A|!bank
	JSL $018022|!bank
;; get pointer for settings
	JSR GetSettings

	PHY
	LDA !151C,x
	BNE ..YoshiCoords
;; set coords for mario
-	LDA $94
	STA $00
	LDA $95
	STA $01
	REP #$20
	LDA $96
	BRA ..SetCoords
..YoshiCoords
;; if mario is riding yoshi, use mario coords
	LDA $187A|!addr
	BNE -
;; if yoshi index is 00, use mario coords
	LDA $18E2|!addr
	BEQ -
	PHX
	DEC
	TAX
	JSR InteractWithYoshi
;; set yoshi coords
	LDA !E4,x
	STA $00
	LDA !14E0,x
	STA $01
	LDA !14D4,x
	XBA
	LDA !D8,x
	PLX
	REP #$20
..SetCoords
;; offset the vertical coords a bit if moving downward
;; (it makes it a bit more consistent)
	LDY !AA,x
	BMI +
	CLC
	ADC #$0010
+	STA $02
	SEP #$20
	PLY

;; set parameters for chasing y speeds
	LDA Settings+$1,y
	XBA
	LDA Settings,y
	JSR .SetParams

;; determine sprite y position relative to stored coords
	PHY
	LDY #$00
	LDA $02
	SEC
	SBC !D8,x
	LDA $03
	SBC !14D4,x
	BPL +
	INY
;; do the funny y speed calculation
+	JSR .DoInvert
	LDA !AA,x
	CLC
	ADC $06,y
-	STA $02
	CLC
	ADC $08
	CMP $09
	BCC +
	LDA !AA,x
	SEC
	SBC $06,y
	BRA -
+	LDA $02
	STA !AA,x
	PLY

;; set parameters for chasing x speeds
	LDA Settings+$3,y
	XBA
	LDA Settings+$2,y
	JSR .SetParams

;; determine sprite x position relative to stored coords
	LDY #$00
	LDA $00
	SEC
	SBC !E4,x
	LDA $01
	SBC !14E0,x
	BPL +
	INY
+	JSR .DoInvert
;; do the funny x speed calculation
	LDA !B6,x
	CLC
	ADC $06,y
-	STA $02
	CLC
	ADC $08
	CMP $09
	BCC +
	LDA !B6,x
	SEC
	SBC $06,y
	BRA -
+	LDA $02
	STA !B6,x
	RTS
.DoInvert
;; just makes it so the speed values to use are inverted if star powered or if no longer chasing
	LDA $1490|!addr
	BNE ++
	LDA !1540,x
	BNE +
++	TYA
	EOR #$01
	TAY
+	RTS

.SetParams
	STA $06
	EOR #$FF
	INC
	STA $07

	XBA
	STA $08
	PHA
	STA $0A
	EOR #$FF
	INC
	STA $0B
	PLA
	ASL
	STA $09
	RTS

InteractWithYoshi:
	PHX
	LDX $15E9|!addr
;; run every 3 frames while !1564,x is 00
	LDA $14
	AND #$03
	ORA !1564,x
	BEQ +
	PLX
	RTS
;; get sprite clipping
+	JSL $03B69F|!bank
	PLX
;; get yoshi position if yoshi is actually holding anything (if not, we don't get collision)
	LDA !160E,x
	BMI .NoYoshiContact
;; get the yoshi clipping
	LDA !1662,x
	PHA
	STZ !1662,x
	JSL $03B6E5|!bank
	PLA
	STA !1662,x
;; check contact
	JSL $03B72B|!bank
	BCC .NoYoshiContact
;; show impact graphic
	PHY
	JSR .ShowImpactGFX
	PLY
	PHX
	LDX $15E9|!addr
	LDA #$10
	STA !1564,x
	LDA !E4,x
	STA $00
	LDA !14E0,x
	STA $01
	PLX
;; spit item
	JSR .SpitItem
;; set running away
	%SubHorzPos()
	LDA .XSpeed,y
	STA !B6,x

	LDA #$02
	STA !C2,x

	LDA #$20
	STA $1DF9|!addr
;; bounce yoshi up if on the ground
	LDA !1588,x
	AND #$04
	BNE .DoJump
	LDA !AA,x
	CMP #$10
	BPL +
.DoJump	LDA #$E0
	STA !AA,x
+	INX
	STX $18DF|!addr
.NoYoshiContact
	RTS
.XSpeed	db -$18,$18

.SpitItem
	LDA #$06
	STA $1DF9|!addr
;; get current direction
	LDA !157C,x
	STA $00
;; get index of mouth sprite
	LDY !160E,x
	STZ $191C|!addr
;; spit sprite and clear mouth sprite index
	STZ !151C,x
	LDA #$03
	STA !1594,x
	LDA #$FF
	STA !160E,x
	STZ $18AC|!addr
	LDA #$18
	STA !1558,x
;; set positions
	LDA !E4,x
	CLC
	PHX
	LDX $00
	ADC $01F305|!bank,x
	PLX
	STA !E4|!dp,y
	LDA !14E0,x
	PHX
	LDX $00
	ADC $01F307|!bank,x
	PLX
	STA !14E0,y

	LDA !D8,x
	STA !D8|!dp,y

	LDA !14D4,x
	STA !14D4,y
;; default smw does this
	LDA #$00
	STA !C2|!dp,y
	STA !15D0,y
	STA !1626,y
	STA !AA|!dp,y
;; set x speeds
	LDA !157C,x
	STA !157C,y
	PHX
	TAX
	LDA $18DC|!addr
	CMP #$01
	LDA #$0A
	BCC +
	INX #2
	LDA #$09
+	STA !14C8,y

	LDA $01F301|!bank,x
	PLX
	STA !B6,y
;; default smw does this if the sprite spawns another sprite for some reason
	LDA !1686,y
	AND #$40
	BEQ +
	PHX
	LDX !9E|!dp,y
	LDA $01A7C9|!bank,x
	PLX
	STA !9E|!dp,y
	PHX
	TYX
	JSL $07F78B|!bank
	PLX
+	RTS

.ShowImpactGFX
	PHX
	LDX $15E9|!addr
	STZ $00
	STZ $01

	LDA #$04
	STA $02

	LDA #$02
	%SpawnSmoke()
	PLX
	RTS

GetSettings:
	LDA !1510,x
	STA $0F
	ASL #2
	ADC $0F
	TAY
	RTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; GFX Routine
!0300	= $0300|!addr
!0301	= $0301|!addr
!0302	= $0302|!addr
!0303	= $0303|!addr
!0460	= $0460|!addr

SubGFX:	%GetDrawInfo()

	STZ $02
	LDA !C2,x
	CMP #$01
	BNE .DrawAttribs
	LDA !1540,x
	CMP #$80
	BCS .DrawAttribs
	CMP #$40
	BCS .SetPalette
	AND #$01
	ASL
	DEC
	STA $02
.DrawAttribs
	PHY
	JSR GetSettings
	LDA Settings+$4,y
	BPL .NormalPal
	LDY !C2,x
	CPY #$02
	BNE .NormalPal
	LDA $14
.NormalPal
	PLY
.SetPalette
	AND #$07
	ASL
	STA $03
.DrawNormal
	%BEC(.NoGiant)
	JMP GiantGFX
	RTS

.NoGiant
	LDA $02
	CLC
	ADC $00
	STA !0300,y

	LDA $01
	CLC
	ADC #$FF
	STA !0301,y

	LDA #!Tile_16X16_Phanto
	STA !0302,y

	LDA !166E,x
	AND #$01
	ORA $03
	AND #$0F
	ORA $64
	STA !0303,y

	LDY #$02
	LDA #$00
	%FinishOAMWrite()
	RTS

GiantGFX:
        PHX
        LDX #$03

.LoopStart        
	PHX
        LDA Giant_Phanto_X_Offset,x
        CLC
        ADC $00
	CLC
	ADC $02
        STA !0300,y
        PLX

        LDA Giant_Phanto_Y_Offset,x
        CLC
        ADC $01
        STA !0301,y

        PHX
        LDA Giant_Phanto_Tiles,x
        STA !0302,y
        PLX

        PHX
	LDA !166E,x
	AND #$01
	ORA $03
	AND #$0F            
	ORA $64
	ORA #$01
        STA !0303,y
        PLX

        INY #4
        DEX
        BPL .LoopStart

        PLX
        LDY #$02                
        LDA #$03
        %FinishOAMWrite()
	RTS